INSERT INTO version (id, release, name, type, description, "date")
VALUES (00004, '7.6', '00004_#patch_add _origin_type_to_visibility_tables.sql', 'FEATURE', '#7219 Microblog-Filter um Herkunft aus Entitäten oder Profilen auf Profilen, Entitäten und persönlichen Startseiten erweitern', now());

-- item_visibility_person
ALTER TABLE item_visibility_person
ADD origin_type VARCHAR2(255 CHAR);

UPDATE item_visibility_person
SET origin_type = 'PROFILE'
WHERE item_type = 'PROFILE';

UPDATE item_visibility_person ivp
SET origin_type = (
    SELECT entity_type
    FROM entity
    WHERE id = ivp.item_id
) 
WHERE item_type = 'ENTITY';

ALTER TABLE item_visibility_person
MODIFY origin_type NOT NULL;

CREATE INDEX itm_vis_pers_otype_idx ON item_visibility_person(origin_type);


-- item_visibility_role
ALTER TABLE item_visibility_role
ADD origin_type VARCHAR2(255 CHAR);

UPDATE item_visibility_role
SET origin_type = 'PROFILE'
WHERE item_type = 'PROFILE';

UPDATE item_visibility_role ivr
SET origin_type = (
    SELECT entity_type
    FROM entity
    WHERE id = ivr.item_id
) 
WHERE item_type = 'ENTITY';

ALTER TABLE item_visibility_role
MODIFY origin_type NOT NULL;

CREATE INDEX itm_vis_role_otype_idx ON item_visibility_role(origin_type);

COMMIT;
